/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Type {
    protected Type() {
    }

    public boolean isObject() {
        return false;
    }

    public abstract <R, D> R accept(Visitor<R, D> var1, D var2);

    protected static void append(StringBuilder sb, String prefix, List<? extends Type> types, String suffix) {
        sb.append(prefix);
        String sep = "";
        for (Type type : types) {
            sb.append(sep);
            sb.append(type);
            sep = ", ";
        }
        sb.append(suffix);
    }

    protected static void appendIfNotEmpty(StringBuilder sb, String prefix, List<? extends Type> types, String suffix) {
        if (types != null && types.size() > 0) {
            Type.append(sb, prefix, types, suffix);
        }
    }

    public static class ArrayType
    extends Type {
        public final Type elemType;

        public ArrayType(Type elemType) {
            this.elemType = elemType;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitArrayType(this, data);
        }

        public String toString() {
            return this.elemType + "[]";
        }
    }

    public static class ClassSigType
    extends Type {
        public final List<TypeParamType> typeParamTypes;
        public final Type superclassType;
        public final List<Type> superinterfaceTypes;

        public ClassSigType(List<TypeParamType> typeParamTypes, Type superclassType, List<Type> superinterfaceTypes) {
            this.typeParamTypes = typeParamTypes;
            this.superclassType = superclassType;
            this.superinterfaceTypes = superinterfaceTypes;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitClassSigType(this, data);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ClassSigType.appendIfNotEmpty(sb, "<", this.typeParamTypes, ">");
            if (this.superclassType != null) {
                sb.append(" extends ");
                sb.append(this.superclassType);
            }
            ClassSigType.appendIfNotEmpty(sb, " implements ", this.superinterfaceTypes, "");
            return sb.toString();
        }
    }

    public static class ClassType
    extends Type {
        public final ClassType outerType;
        public final String name;
        public final List<Type> typeArgs;

        public ClassType(ClassType outerType, String name, List<Type> typeArgs) {
            this.outerType = outerType;
            this.name = name;
            this.typeArgs = typeArgs;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitClassType(this, data);
        }

        public String getBinaryName() {
            if (this.outerType == null) {
                return this.name;
            }
            return String.valueOf(this.outerType.getBinaryName()) + "$" + this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.outerType != null) {
                sb.append(this.outerType);
                sb.append(".");
            }
            sb.append(this.name);
            ClassType.appendIfNotEmpty(sb, "<", this.typeArgs, ">");
            return sb.toString();
        }

        @Override
        public boolean isObject() {
            return this.outerType == null && this.name.equals("java/lang/Object") && (this.typeArgs == null || this.typeArgs.isEmpty());
        }
    }

    public static class MethodType
    extends Type {
        public final List<? extends TypeParamType> typeParamTypes;
        public final List<? extends Type> paramTypes;
        public final Type returnType;
        public final List<? extends Type> throwsTypes;

        public MethodType(List<? extends Type> paramTypes, Type resultType) {
            this(null, paramTypes, resultType, null);
        }

        public MethodType(List<? extends TypeParamType> typeParamTypes, List<? extends Type> paramTypes, Type returnType, List<? extends Type> throwsTypes) {
            this.typeParamTypes = typeParamTypes;
            this.paramTypes = paramTypes;
            this.returnType = returnType;
            this.throwsTypes = throwsTypes;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodType(this, data);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            MethodType.appendIfNotEmpty(sb, "<", this.typeParamTypes, "> ");
            sb.append(this.returnType);
            MethodType.append(sb, " (", this.paramTypes, ")");
            MethodType.appendIfNotEmpty(sb, " throws ", this.throwsTypes, "");
            return sb.toString();
        }
    }

    public static class SimpleType
    extends Type {
        private static final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short", "void"));
        public final String name;

        public SimpleType(String name) {
            this.name = name;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitSimpleType(this, data);
        }

        public boolean isPrimitiveType() {
            return primitiveTypes.contains(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TypeParamType
    extends Type {
        public final String name;
        public final Type classBound;
        public final List<Type> interfaceBounds;

        public TypeParamType(String name, Type classBound, List<Type> interfaceBounds) {
            this.name = name;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitTypeParamType(this, data);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            String sep = " extends ";
            if (this.classBound != null) {
                sb.append(sep);
                sb.append(this.classBound);
                sep = " & ";
            }
            if (this.interfaceBounds != null) {
                for (Type bound : this.interfaceBounds) {
                    sb.append(sep);
                    sb.append(bound);
                    sep = " & ";
                }
            }
            return sb.toString();
        }
    }

    public static interface Visitor<R, P> {
        public R visitSimpleType(SimpleType var1, P var2);

        public R visitArrayType(ArrayType var1, P var2);

        public R visitMethodType(MethodType var1, P var2);

        public R visitClassSigType(ClassSigType var1, P var2);

        public R visitClassType(ClassType var1, P var2);

        public R visitTypeParamType(TypeParamType var1, P var2);

        public R visitWildcardType(WildcardType var1, P var2);
    }

    public static class WildcardType
    extends Type {
        public final Kind kind;
        public final Type boundType;

        public WildcardType() {
            this(Kind.UNBOUNDED, null);
        }

        public WildcardType(Kind kind, Type boundType) {
            this.kind = kind;
            this.boundType = boundType;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitWildcardType(this, data);
        }

        public String toString() {
            switch (this.kind) {
                case UNBOUNDED: {
                    return "?";
                }
                case EXTENDS: {
                    return "? extends " + this.boundType;
                }
                case SUPER: {
                    return "? super " + this.boundType;
                }
            }
            throw new AssertionError();
        }

        public static enum Kind {
            UNBOUNDED,
            EXTENDS,
            SUPER;

        }
    }
}

