
import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class UDP_TX extends VHDLSimpleLibrary implements JavaRockComponentIface{

  public int dest_ip;
  public int dest_port;
  public int src_ip;
  public int src_port;

  public int data_length;

  public int[] data;

  public boolean start;
  public boolean busy;

  public UDP_TX(String... args){
    super("udp_tx_wrapper", args);

    ports.add(new VHDLPort(this, "clk",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "reset",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "UPL_OUT_Data", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT, VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_Req",  VHDLTypeBuilder.getStdLogic(),            VHDLPort.Dir.OUT, VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_Ack",  VHDLTypeBuilder.getStdLogic(),            VHDLPort.Dir.IN,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_En",   VHDLTypeBuilder.getStdLogic(),            VHDLPort.Dir.OUT, VHDLPort.Kind.EXTERNAL));

    ports.add(new VHDLPort(this, "data_length", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "start",    VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "busy",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT));
    
    ports.add(new VHDLPort(this, "data_waddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_wdata", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_we",    VHDLTypeBuilder.getStdLogicVector(0, 0), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "dest_ip",   VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "dest_port", VHDLTypeBuilder.getStdLogicVector(15, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "src_ip",    VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "src_port",  VHDLTypeBuilder.getStdLogicVector(15, 0), VHDLPort.Dir.IN));
  }

}
