library ieee;
use ieee.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

library WORK;
use WORK.constants.all;

library unisim;
use unisim.vcomponents.all;

--@SETPARAM chip.clock sSystem50MHz
--@SETPARAM chip.reset sSystem_Reset_N
--@SETPARAM upldebugduplexer.src_ip X"ffffffff"
--@SETPARAM upldebugduplexer.dst_ip X"ffffffff"
--@SETPARAM upldebugduplexer.joint_width 32

entity top is
  port(
    -- VXeNbN
    USER_CLOCK      : in  std_logic;

    -- GMII PHY : 2.5V
    ETH_RESET_N : out   std_logic;      -- chipɂVXeZbgo
    -- MAC I/F
    ETH_COL     : in    std_logic;  -- CollisionDetect/MAC_FREQpsBO2kPUĂBMAC_CLKo͂125MHzɂĂlB
    ETH_CRS     : in    std_logic;  -- CarrierSence/RGMII_SEL0psBO2kPDĂB
    ETH_TX_CLK  : in    std_logic;  -- TXCLK/RGMII_SEL1psBO2kPDĂBCRSƍ킹GMII[hɂĂB
    -- TX out
    ETH_TX_D    : out   std_logic_vector(3 downto 0);  -- Mf[^
    ETH_TX_EN   : out   std_logic;
    -- RX in
    ETH_RX_D    : in    std_logic_vector(3 downto 0);  -- Mf[^
    ETH_RX_CLK  : in    std_logic;  -- 10M=>2.5MHz, 100M=>25MHz, 1G=>125MHz ̃NbN
    ETH_RX_DV   : in    std_logic;
    ETH_RX_ER   : in    std_logic;
    -- Management I/F
    ETH_MDC     : out   std_logic;      -- NbNóBmax.2.5MHzB
    ETH_MDIO    : inout std_logic;      -- Rg[f[^B
    ETH_PDW     : out   std_logic;

    -- Asynchronous Reset
    USER_RESET : in std_logic;

    Gpio_DIP : in  std_logic_vector(3 downto 0);
    Gpio_LED : out std_logic_vector(3 downto 0);

    fpga_ex_io : out std_logic_vector(29 downto 0);

--    fpga_ex_cclk : out std_logic;
--    fpga_ex_cso  : out std_logic;
--    fpga_ex_din  : in  std_logic;
--    fpga_ex_mosi : out std_logic;

    FPGA_CCLK : out std_logic;
    FPGA_CSO  : out std_logic;
    FPGA_DIN  : in  std_logic;
    FPGA_MOSI : out std_logic;

    PMOD_P1  : inout std_logic;
    PMOD_P2  : inout std_logic;
    PMOD_P3  : inout std_logic;
    PMOD_P4  : inout std_logic;
    PMOD_P7  : inout std_logic;
    PMOD_P8  : inout std_logic;
    PMOD_P9  : inout std_logic;
    PMOD_P10 : inout std_logic
   );
end top;
architecture RTL of top is

  component e7udpip100M_spartan6 is 
  port(
    -- GMII PHY : 2.5V
    EPHY_RST_N    : out   std_logic ;  -- chipɂVXeZbgo
    EPHY_MAC_CLK  : in    std_logic ;  -- PHY25MHzCLK
    -- MAC I/F
    EPHY_COL      : in    std_logic ;  -- CollisionDetect/MAC_FREQpsBO2kPUĂBMAC_CLKo͂125MHzɂĂlB
    EPHY_CRS      : in    std_logic ;  -- CarrierSence/RGMII_SEL0psBO2kPDĂB
    EPHY_TXCLK    : in    std_logic ;  -- TXCLK/RGMII_SEL1psBO2kPDĂBCRSƍ킹GMII[hɂĂB
    -- TX out
    EPHY_TD       : out   std_logic_vector( 3 downto 0 ) ;  -- Mf[^
    EPHY_TXEN     : out   std_logic ;
    EPHY_TXER     : out   std_logic ;
    -- RX in
    EPHY_RD       : in    std_logic_vector( 3 downto 0 ) ;  -- Mf[^
    EPHY_RXCLK    : in    std_logic ;  -- 10M=>2.5MHz, 100M=>25MHz, 1G=>125MHz ̃NbN
    EPHY_RXDV     : in    std_logic ;
    EPHY_RXER     : in    std_logic ;
    -- Management I/F
    EPHY_MDC      : out   std_logic ;  -- NbNóBmax.2.5MHzB
    EPHY_MDIO     : inout std_logic ;  -- Rg[f[^B
    EPHY_INT_N    : in    std_logic ;  -- C^vgB

    -- Asynchronous Reset
    Reset_n        : in  std_logic;

    -- UPL interface
    pUPLGlobalClk : in  std_logic;
    -- UDP tx input
    pUdp0Send_Data       : in  std_logic_vector( 31 downto 0 );
    pUdp0Send_Request    : in  std_logic;
    pUdp0Send_Ack        : out std_logic;
    pUdp0Send_Enable     : in  std_logic;

    pUdp1Send_Data       : in  std_logic_vector( 31 downto 0 );
    pUdp1Send_Request    : in  std_logic;
    pUdp1Send_Ack        : out std_logic;
    pUdp1Send_Enable     : in  std_logic;

    -- UDP rx output
    pUdp0Receive_Data       : out std_logic_vector( 31 downto 0 );
    pUdp0Receive_Request    : out std_logic;
    pUdp0Receive_Ack        : in  std_logic;
    pUdp0Receive_Enable     : out std_logic;

    pUdp1Receive_Data       : out std_logic_vector( 31 downto 0 );
    pUdp1Receive_Request    : out std_logic;
    pUdp1Receive_Ack        : in  std_logic;
    pUdp1Receive_Enable     : out std_logic;

    -- Setup
    pMyIpAddr       : in std_logic_vector( 31 downto 0 );
    pMyMacAddr      : in std_logic_vector( 47 downto 0 );
    pMyNetmask      : in std_logic_vector( 31 downto 0 );
    pDefaultGateway : in std_logic_vector( 31 downto 0 );
    pTargetIPAddr   : in std_logic_vector( 31 downto 0 );
    pMyUdpPort0     : in std_logic_vector( 15 downto 0 );
    pMyUdpPort1     : in std_logic_vector( 15 downto 0 );

    -- Status
    pStatus_RxByteCount             : out std_logic_vector( 31 downto 0 );
    pStatus_RxPacketCount           : out std_logic_vector( 31 downto 0 );
    pStatus_RxErrorPacketCount      : out std_logic_vector( 15 downto 0 );
    pStatus_RxDropPacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_RxARPRequestPacketCount : out std_logic_vector( 15 downto 0 );
    pStatus_RxARPReplyPacketCount   : out std_logic_vector( 15 downto 0 );
    pStatus_RxICMPPacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_RxUDP0PacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_RxUDP1PacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_RxIPErrorPacketCount    : out std_logic_vector( 15 downto 0 );
    pStatus_RxUDPErrorPacketCount   : out std_logic_vector( 15 downto 0 );

    pStatus_TxByteCount             : out std_logic_vector( 31 downto 0 );
    pStatus_TxPacketCount           : out std_logic_vector( 31 downto 0 );
    pStatus_TxARPRequestPacketCount : out std_logic_vector( 15 downto 0 );
    pStatus_TxARPReplyPacketCount   : out std_logic_vector( 15 downto 0 );
    pStatus_TxICMPReplyPacketCount  : out std_logic_vector( 15 downto 0 );
    pStatus_TxUDP0PacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_TxUDP1PacketCount       : out std_logic_vector( 15 downto 0 );
    pStatus_TxMulticastPacketCount  : out std_logic_vector( 15 downto 0 );

    pdebug : out std_logic_vector(63 downto 0)
    );
  end component;

  component dcm_25to50_sp6_xilinx_14_x
    port
      (-- Clock in ports
        CLK_IN1           : in     std_logic;  -- assumed 25MHz
        -- Clock out ports
        CLK_OUT1          : out    std_logic;  -- 50MHz
        CLK_OUT2          : out    std_logic;  -- 25MHz
        -- Status and control signals
        RESET             : in     std_logic;
        LOCKED            : out    std_logic
        );
  end component;

  component fpgamain
    port (
      udp_tx_UPL_OUT_Req     : OUT std_logic;
      notify_method_busy     : OUT std_logic;
      udp_tx_UPL_OUT_Data    : OUT std_logic_vector(31 downto 0);
      storage_rom_M25P40_C   : OUT std_logic;
      udp_tx_UPL_OUT_En      : OUT std_logic;
      udp_rx_UPL_IN_Ack      : OUT std_logic;
      storage_rom_M25P40_S   : OUT std_logic;
      storage_rom_M25P40_DQ0 : OUT std_logic;
      notify_method_request  : IN  std_logic;
      udp_rx_UPL_IN_Req      : IN  std_logic;
      udp_rx_UPL_IN_Data     : IN  std_logic_vector(31 downto 0);
      udp_tx_UPL_OUT_Ack     : IN  std_logic;
      udp_rx_UPL_IN_En       : IN  std_logic;
      reset                  : IN  std_logic;
      storage_rom_M25P40_DQ1 : IN  std_logic;
      clk                    : IN  std_logic
      );
  end component;

  -- Global asynchronous reset
  signal reset_n : std_logic;
  signal reset_i : std_logic;

  -- create a synchronous reset in the transmitter clock domain
  signal ll_pre_reset_0_i : std_logic_vector(5 downto 0);
  signal ll_reset_0_i     : std_logic;

  attribute async_reg : string;
  attribute async_reg of ll_pre_reset_0_i : signal is "true";

  -- Global synchronous clock and reset
  signal sSystem50MHz   : std_logic;
  signal sSystem_Reset_n : std_logic;
  signal sEMAC25MHz      : std_logic;

  signal UDP0Send    : UPL32;
  
    -- 玩Iɐ錾ǉ܂
    signal low : std_logic;
    signal high : std_logic;
    signal low1 : std_logic_vector( 0 downto 0 );
    signal low4 : std_logic_vector( 3 downto 0 );
    signal low8 : std_logic_vector( 7 downto 0 );
    signal low16 : std_logic_vector( 15 downto 0 );
    signal low32 : std_logic_vector( 31 downto 0 );
    signal low64 : std_logic_vector( 63 downto 0 );
    
    signal UPL8low   : UPL8;            -- nouplmonitor
    signal UPL32low  : UPL32;           -- nouplmonitor
    signal UPL64low  : UPL64;           -- nouplmonitor
    signal UPL8open  : UPL8;            -- nouplmonitor
    signal UPL32open : UPL32;           -- nouplmonitor
    signal UPL64open : UPL64;           -- nouplmonitor
    -- ܂ŎIɐ錾ǉ܂
    
  signal UDP0Receive : UPL32;  -- Xe[ggړ܂
  signal UDP1Receive : UPL32;  -- Xe[ggړ܂
  signal DefaultMyIpAddr       : std_logic_vector(31 downto 0) := X"0a000001";  -- Xe[ggړ܂
  signal DefaultMyMacAddr      : std_logic_vector(47 downto 0) := X"001b1aee0000";  -- Xe[ggړ܂
  signal DefaultDefaultGateway : std_logic_vector(31 downto 0) := X"0a0000fe";  -- Xe[ggړ܂
  signal DefaultMyNetmask      : std_logic_vector(31 downto 0) := X"ff000000";  -- Xe[ggړ܂
  signal MyIpAddr       : std_logic_vector(31 downto 0) := X"0a000001";  -- Xe[ggړ܂
  signal MyMacAddr      : std_logic_vector(47 downto 0) := X"001b1aee0000";  -- Xe[ggړ܂
  signal DefaultGateway : std_logic_vector(31 downto 0) := X"0a0000fe";  -- Xe[ggړ܂
  signal MyNetmask      : std_logic_vector(31 downto 0) := X"ff000000";  -- Xe[ggړ܂
  signal MyUdpPort0     : std_logic_vector(15 downto 0) := X"4000";  -- Xe[ggړ܂
  signal MyUdpPort1     : std_logic_vector(15 downto 0) := X"4001";  -- Xe[ggړ܂
  signal serveripaddr   : std_logic_vector(31 downto 0) := X"0a000003";  -- Xe[ggړ܂
  signal Status_RxByteCount             : std_logic_vector( 31 downto 0 );  -- Xe[ggړ܂
  signal Status_RxPacketCount           : std_logic_vector( 31 downto 0 );  -- Xe[ggړ܂
  signal Status_RxErrorPacketCount      : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxDropPacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxARPRequestPacketCount : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxARPReplyPacketCount   : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxICMPPacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxUDP0PacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxUDP1PacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxIPErrorPacketCount    : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_RxUDPErrorPacketCount   : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxByteCount             : std_logic_vector( 31 downto 0 );  -- Xe[ggړ܂
  signal Status_TxPacketCount           : std_logic_vector( 31 downto 0 );  -- Xe[ggړ܂
  signal Status_TxARPRequestPacketCount : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxARPReplyPacketCount   : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxICMPReplyPacketCount  : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxUDP0PacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxUDP1PacketCount       : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal Status_TxMulticastPacketCount  : std_logic_vector( 15 downto 0 );  -- Xe[ggړ܂
  signal sSystem_Reset : std_logic;  -- Xe[ggړ܂
  signal UDP3Send : UPL32;  -- Xe[ggړ܂
  signal UART_TX, UART_RX : std_logic;  -- Xe[ggړ܂
    signal cvhd2vhd_ipbus_duplexer_output : UPL32;

    -- W[j^[M͎łBmۂBUS̓[Uwl̍őlłB
    --GENE_MODULEMONITORw肪̂"modulecontrol_statusidle"͍܂B[Uw蕝MAX(0)Ao^(0)
    --GENE_MODULERESETw肪̂"modulecontrol_funcreset"͍܂B[Uw蕝MAX(0)Ao^(0) activeŒ肵܂
    -- W[j^[M܂

    -- UPLj^[M͎łBmۂBUS̓[Uwl̍őlłB
    --GENE_UPLMONITORw肪̂"uplmonitor"͍܂B[Uw蕝MAX(0)Ao^(5)
    --GENE_UPLENABLEw肪̂"uplenable"͍܂B[Uw蕝MAX(0)Ao^(5)
    --GENE_UPLREQUESTw肪̂"uplrequest"͍܂B[Uw蕝MAX(0)Ao^(5)
    -- UPLj^[M܂

begin

  U_DCM : dcm_25to50_sp6_xilinx_14_x
    port map (
      -- Clock in ports
      CLK_IN1 => USER_CLOCK,
      -- Clock out ports
      CLK_OUT1 => sSystem50MHz,
      CLK_OUT2 => sEMAC25MHz,
      --   Status and control signals
      RESET  => not USER_RESET,
      LOCKED => open
      );

--     IOBUF_inst : IOBUF port map (
--       O => MDIO_0_I,
--       IO => GEPHY0_MDIO,
--       I => MDIO_0_O,
--       T => MDIO_0_T );

  -- Create synchronous reset in the system clock domain.
  Reset_n <= USER_RESET;
  gen_ll_reset_emac0 : process (sSystem50MHz, Reset_n)
  begin
      if ( Reset_n = '0') then
        ll_pre_reset_0_i <= (others => '1');
        ll_reset_0_i     <= '1';
      elsif (sSystem50MHz'event and sSystem50MHz = '1') then
        ll_pre_reset_0_i(0)          <= '0';
        ll_pre_reset_0_i(5 downto 1) <= ll_pre_reset_0_i(4 downto 0);
        ll_reset_0_i                 <= ll_pre_reset_0_i(5);
      end if;
  end process;

  sSystem_Reset_n <= not ll_reset_0_i;
  
  ETH_PDW <= high;

  u_e7udpip0 : e7udpip100M_spartan6
    port map (
      -- GMII PHY : 2.5V
      EPHY_RST_N    => ETH_RESET_N,
      EPHY_MAC_CLK  => sEMAC25MHz, -- USER_CLOCK,
      -- MAC I/F
      EPHY_COL      => ETH_COL,
      EPHY_CRS      => ETH_CRS,
      EPHY_TXCLK    => ETH_TX_CLK,
      -- TX out
      EPHY_TD       => ETH_TX_D,
      EPHY_TXEN     => ETH_TX_EN,
      EPHY_TXER     => open,
      -- RX in
      EPHY_RD       => ETH_RX_D,
      EPHY_RXCLK    => ETH_RX_CLK,
      EPHY_RXDV     => ETH_RX_DV,
      EPHY_RXER     => ETH_RX_ER,
      -- Management I/F
      EPHY_MDC      => ETH_MDC,
      EPHY_MDIO     => ETH_MDIO,
      EPHY_INT_N    => high,

      -- Asynchronous Reset
      Reset_n       => Reset_n,
      -- UPL interface
--      pUPLGlobalClk => sSystem50MHz,
      pUPLGlobalClk => sEMAC25MHz,
      -- UDP tx input
      pUdp0Send_Data       => UDP0Send.Data,
      pUdp0Send_Request    => UDP0Send.Request,
      pUdp0Send_Ack        => UDP0Send.Ack,
      pUdp0Send_Enable     => UDP0Send.Enable,

--      pUdp1Send_Data       => UDP1Send.Data,
--      pUdp1Send_Request    => UDP1Send.Request,
--      pUdp1Send_Ack        => UDP1Send.ACK,
--      pUdp1Send_Enable     => UDP1Send.Enable,
      pUdp1Send_Data       => (others => '0'), -- Udp1Receive.Data,
      pUdp1Send_Request    => '0',             -- Udp1Receive.Request,
      pUdp1Send_Ack        => open,            -- Udp1Receive.Ack,
      pUdp1Send_Enable     => '0',             -- Udp1Receive.Enable,

      -- UDP rx output
      pUdp0Receive_Data       => Udp0Receive.Data,
      pUdp0Receive_Request    => Udp0Receive.Request,
      pUdp0Receive_Ack        => Udp0Receive.Ack,
      pUdp0Receive_Enable     => Udp0Receive.Enable,

      pUdp1Receive_Data       => open,  -- Udp1Receive.Data,
      pUdp1Receive_Request    => open,  -- Udp1Receive.Request,
      pUdp1Receive_Ack        => '0',   -- Udp1Receive.Ack,
      pUdp1Receive_Enable     => open,  -- Udp1Receive.Enable,

      -- Setup
      pMyIpAddr     => MyIpAddr,
      pMyMacAddr    => MyMacAddr,
      pMyNetmask    => MyNetmask,
      pDefaultGateway => DefaultGateway,
      pMyUdpPort0   => MyUdpPort0,
      pMyUdpPort1   => MyUdpPort1,
      pTargetIpAddr => serveripaddr,

      -- Status
      pStatus_RxByteCount             => Status_RxByteCount,
      pStatus_RxPacketCount           => Status_RxPacketCount,
      pStatus_RxErrorPacketCount      => Status_RxErrorPacketCount,
      pStatus_RxDropPacketCount       => Status_RxDropPacketCount,
      pStatus_RxARPRequestPacketCount => Status_RxARPRequestPacketCount,
      pStatus_RxARPReplyPacketCount   => Status_RxARPReplyPacketCount,
      pStatus_RxICMPPacketCount       => Status_RxICMPPacketCount,
      pStatus_RxUDP0PacketCount       => Status_RxUDP0PacketCount,
      pStatus_RxUDP1PacketCount       => Status_RxUDP1PacketCount,
      pStatus_RxIPErrorPacketCount    => Status_RxIPErrorPacketCount,
      pStatus_RxUDPErrorPacketCount   => Status_RxUDPErrorPacketCount,

      pStatus_TxByteCount             => Status_TxByteCount,
      pStatus_TxPacketCount           => Status_TxPacketCount,
      pStatus_TxARPRequestPacketCount => Status_TxARPRequestPacketCount,
      pStatus_TxARPReplyPacketCount   => Status_TxARPReplyPacketCount,
      pStatus_TxICMPReplyPacketCount  => Status_TxICMPReplyPacketCount,
      pStatus_TxUDP0PacketCount       => Status_TxUDP0PacketCount,
      pStatus_TxUDP1PacketCount       => Status_TxUDP1PacketCount,
      pStatus_TxMulticastPacketCount  => Status_TxMulticastPacketCount

--        pdebug => pdebug
    );
--   signal UDP0Receive : UPL32;-- 錾Ɉړ܂
--   signal UDP1Receive : UPL32;-- 錾Ɉړ܂
  
--   signal DefaultMyIpAddr       : std_logic_vector(31 downto 0) := X"0a000001";-- 錾Ɉړ܂
--   signal DefaultMyMacAddr      : std_logic_vector(47 downto 0) := X"001b1aee0000";-- 錾Ɉړ܂
--   signal DefaultDefaultGateway : std_logic_vector(31 downto 0) := X"0a0000fe";-- 錾Ɉړ܂
--   signal DefaultMyNetmask      : std_logic_vector(31 downto 0) := X"ff000000";-- 錾Ɉړ܂

--   signal MyIpAddr       : std_logic_vector(31 downto 0) := X"0a000001";-- 錾Ɉړ܂
--   signal MyMacAddr      : std_logic_vector(47 downto 0) := X"001b1aee0000";-- 錾Ɉړ܂
--   signal DefaultGateway : std_logic_vector(31 downto 0) := X"0a0000fe";-- 錾Ɉړ܂
--   signal MyNetmask      : std_logic_vector(31 downto 0) := X"ff000000";-- 錾Ɉړ܂
--   signal MyUdpPort0     : std_logic_vector(15 downto 0) := X"4000";-- 錾Ɉړ܂
--   signal MyUdpPort1     : std_logic_vector(15 downto 0) := X"4001";-- 錾Ɉړ܂
--   signal serveripaddr   : std_logic_vector(31 downto 0) := X"0a000003";-- 錾Ɉړ܂

--   signal Status_RxByteCount             : std_logic_vector( 31 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxPacketCount           : std_logic_vector( 31 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxErrorPacketCount      : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxDropPacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxARPRequestPacketCount : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxARPReplyPacketCount   : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxICMPPacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxUDP0PacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxUDP1PacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxIPErrorPacketCount    : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_RxUDPErrorPacketCount   : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂

--   signal Status_TxByteCount             : std_logic_vector( 31 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxPacketCount           : std_logic_vector( 31 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxARPRequestPacketCount : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxARPReplyPacketCount   : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxICMPReplyPacketCount  : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxUDP0PacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxUDP1PacketCount       : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂
--   signal Status_TxMulticastPacketCount  : std_logic_vector( 15 downto 0 );-- 錾Ɉړ܂

  Gpio_LED <= not Gpio_DIP;
--  Gpio_LED(2 downto 0) <= not Gpio_DIP(2 downto 0);  
  
--  pDebug <= (others => '0');

--   signal sSystem_Reset : std_logic;-- 錾Ɉړ܂
  sSystem_Reset <= not sSystem_Reset_n;

--   signal UDP3Send : UPL32;-- 錾Ɉړ܂

  U_FPGAMAIN: fpgamain
    port map(
      reset => sSystem_Reset,
--      clk   => sSystem50MHz,
      clk   => sEMAC25MHz,

      udp_rx_UPL_IN_Req      => UDP0Receive.Request,
      udp_rx_UPL_IN_Data     => UDP0Receive.Data,
      udp_rx_UPL_IN_Ack      => UDP0Receive.Ack,
      udp_rx_UPL_IN_En       => UDP0Receive.Enable,

      udp_tx_UPL_OUT_Ack     => UDP0Send.Ack,
      udp_tx_UPL_OUT_Req     => UDP0Send.Request,
      udp_tx_UPL_OUT_Data    => UDP0Send.Data,
      udp_tx_UPL_OUT_En      => UDP0Send.Enable,
      
      storage_rom_M25P40_C   => FPGA_CCLK,
      storage_rom_M25P40_DQ0 => FPGA_MOSI,
      storage_rom_M25P40_DQ1 => FPGA_DIN,
      storage_rom_M25P40_S   => FPGA_CSO,
      
      notify_method_busy    => open,
      notify_method_request => '0'
      );

--  UART_TX <= UART_RX;
--  M25PE10_REQ_FPGAMAIN <= '0';
  
--   signal UART_TX, UART_RX : std_logic;-- 錾Ɉړ܂

  MyIpAddr       <= DefaultMyIpAddr;
  MyMacAddr      <= DefaultMyMacAddr;
  MyNetmask      <= DefaultMyNetmask;
  DefaultGateway <= DefaultDefaultGateway;
  

  fpga_ex_io <= (others => 'Z');

  UART_RX <= PMOD_P1;
  PMOD_P2 <= UART_TX;
  PMOD_P3 <= '0';
  PMOD_P4 <= '0';
  
    -- 玩IɋLqǉ܂
    low <= '0';
    high <= '1';
    low1 <= B"0";
    low4 <= X"0";
    low8 <= X"00";
    low16 <= X"0000";
    low32 <= X"00000000";
    low64 <= low32 & low32;
    -- gpUPL̓̓sŒ
    UPL8low.Enable <= low;
    UPL8low.Request <= low;
    UPL8low.Data <= low8;
    UPL32low.Enable <= low;
    UPL32low.Request <= low;
    UPL32low.Data <= low32;
    UPL64low.Enable <= low;
    UPL64low.Request <= low;
    UPL64low.Data <= low64;
    UPL8open.Ack <= high;
    UPL32open.Ack <= high;
    UPL64open.Ack <= high;
    -- ܂ŎIɋLqǉ܂
    
    cvhd2vhd_ipbus_duplexer_output.Enable <= low;
    cvhd2vhd_ipbus_duplexer_output.Request <= low;
    cvhd2vhd_ipbus_duplexer_output.Data <= low32;

    -- W[j^[M͎łBBUSւ̐ڑ"MODULECONTROL"(BASE)錾łB
    -- W[j^[M܂

    -- UPLj^[M͎łBBUSւ̐ڑ"signal"錾łB
    -- UPLj^[M܂

end RTL;
