library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity m25p40if is
  port (
    notify_method_busy : OUT std_logic;
    rom_M25P40_C : OUT std_logic;
    buf_read_method_busy : OUT std_logic;
    rom_M25P40_S : OUT std_logic;
    read_bytes_method_busy : OUT std_logic;
    page_program_method_busy : OUT std_logic;
    rom_M25P40_DQ0 : OUT std_logic;
    sector_erase_method_busy : OUT std_logic;
    buf_write_method_busy : OUT std_logic;
    output_port_buf_read : OUT std_logic_vector(7 downto 0);
    input_port_sector_erase_addr : IN std_logic_vector(31 downto 0);
    input_port_page_program_addr : IN std_logic_vector(31 downto 0);
    input_port_buf_read_index : IN std_logic_vector(31 downto 0);
    input_port_read_bytes_addr : IN std_logic_vector(31 downto 0);
    input_port_buf_write_index : IN std_logic_vector(31 downto 0);
    buf_write_method_request : IN std_logic;
    input_port_buf_write_data : IN std_logic_vector(7 downto 0);
    clk : IN std_logic;
    notify_method_request : IN std_logic;
    sector_erase_method_request : IN std_logic;
    read_bytes_method_request : IN std_logic;
    buf_read_method_request : IN std_logic;
    rom_M25P40_DQ1 : IN std_logic;
    reset : IN std_logic;
    page_program_method_request : IN std_logic;
    input_port_read_bytes_length : IN std_logic_vector(31 downto 0);
    input_port_page_program_length : IN std_logic_vector(31 downto 0)
  );
end m25p40if;

architecture RTL of m25p40if is
  component vhdl_m25p40_buf_wrapper
    port (
      clk : IN std_logic;
      reset : IN std_logic;
      M25P40_C : OUT std_logic;
      M25P40_DQ0 : OUT std_logic;
      M25P40_DQ1 : IN std_logic;
      M25P40_S : OUT std_logic;
      req : IN std_logic;
      busy : OUT std_logic;
      command : IN std_logic_vector(7 downto 0);
      addr : IN std_logic_vector(31 downto 0);
      length : IN std_logic_vector(31 downto 0);
      data_waddr : IN std_logic_vector(31 downto 0);
      data_wdata : IN std_logic_vector(7 downto 0);
      data_we : IN std_logic_vector(0 downto 0);
      data_raddr : IN std_logic_vector(31 downto 0);
      data_rdata : OUT std_logic_vector(7 downto 0)
    );
  end component;
  constant READ_IDENTIFICATION : integer := 159;
  constant READ_DATA_BYTES : integer := 3;
  constant RELEASE_FROM_DEEP_POWER_DOWN : integer := 171;
  constant WRITE_DISABLE : integer := 4;
  constant WRITE_ENABLE : integer := 6;
  constant SECTOR_ERASE : integer := 216;
  constant READ_DATA_BYTES_AT_HIGHER_SPEED : integer := 11;
  constant READ_STATUS_REGISTER : integer := 5;
  constant WRITE_STATUS_REGISTER : integer := 1;
  constant PAGE_PROGRAM : integer := 2;
  constant DEEP_POWER_DOWN : integer := 185;
  constant BULK_ERASE : integer := 199;
  signal rom_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_length_field_wdata_reset_strobe : std_logic := '0';
  signal rom_length_field_wdata_writer_emit_command_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_length_field_wdata_writer_strobe_emit_command_method_state : std_logic := '0';
  signal rom_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_waddr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_waddr_field_wdata_reset_strobe : std_logic := '0';
  signal rom_data_waddr_field_wdata_writer_buf_write_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_waddr_field_wdata_writer_strobe_buf_write_method_state : std_logic := '0';
  signal rom_data_waddr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_waddr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_command_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_command_field_wdata_reset_strobe : std_logic := '0';
  signal rom_command_field_wdata_writer_emit_command_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_command_field_wdata_writer_strobe_emit_command_method_state : std_logic := '0';
  signal rom_command_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_command_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal rom_data_we_field_wdata_reset : std_logic_vector(0 downto 0) := (others => '0');
  signal rom_data_we_field_wdata_reset_strobe : std_logic := '0';
  signal rom_data_we_field_wdata_writer_buf_write_method_state : std_logic_vector(0 downto 0) := (others => '0');
  signal rom_data_we_field_wdata_writer_strobe_buf_write_method_state : std_logic := '0';
  signal rom_data_we_field_rdata : std_logic_vector(0 downto 0) := (others => '0');
  signal rom_data_we_field_wdata : std_logic_vector(0 downto 0) := (others => '0');
  signal rom_req_field_wdata_reset : std_logic := '0';
  signal rom_req_field_wdata_reset_strobe : std_logic := '0';
  signal rom_req_field_wdata_writer_emit_command_method_state : std_logic := '0';
  signal rom_req_field_wdata_writer_strobe_emit_command_method_state : std_logic := '0';
  signal rom_req_field_rdata : std_logic := '0';
  signal rom_req_field_wdata : std_logic := '0';
  signal rom_data_rdata_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_data_rdata_field_wdata_reset_strobe : std_logic := '0';
  signal rom_data_rdata_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_data_rdata_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_busy_field_wdata_reset : std_logic := '0';
  signal rom_busy_field_wdata_reset_strobe : std_logic := '0';
  signal rom_busy_field_rdata : std_logic := '0';
  signal rom_busy_field_wdata : std_logic := '0';
  signal rom_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_addr_field_wdata_reset_strobe : std_logic := '0';
  signal rom_addr_field_wdata_writer_emit_command_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_addr_field_wdata_writer_strobe_emit_command_method_state : std_logic := '0';
  signal rom_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_emit_command_command_field_wdata_writer_state_counter_wait_wip_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal this_input_port_emit_command_command_field_wdata_writer_page_program_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_writer_strobe_page_program_method_state : std_logic := '0';
  signal this_input_port_emit_command_command_field_wdata_writer_read_bytes_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_writer_strobe_read_bytes_method_state : std_logic := '0';
  signal this_input_port_emit_command_command_field_wdata_writer_sector_erase_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata_writer_strobe_sector_erase_method_state : std_logic := '0';
  signal this_input_port_emit_command_command_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_command_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_wip_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata_writer_page_program_method_state : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata_writer_strobe_page_program_method_state : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata_writer_sector_erase_method_state : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata_writer_strobe_sector_erase_method_state : std_logic := '0';
  signal this_wait_wip_method_request_field_rdata : std_logic := '0';
  signal this_wait_wip_method_request_field_wdata : std_logic := '0';
  signal rom_data_raddr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_raddr_field_wdata_reset_strobe : std_logic := '0';
  signal rom_data_raddr_field_wdata_writer_buf_read_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_raddr_field_wdata_writer_strobe_buf_read_method_state : std_logic := '0';
  signal rom_data_raddr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_raddr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal rom_data_raddr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal rom_data_raddr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_emit_command_length_field_wdata_writer_state_counter_wait_wip_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal this_input_port_emit_command_length_field_wdata_writer_page_program_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_writer_strobe_page_program_method_state : std_logic := '0';
  signal this_input_port_emit_command_length_field_wdata_writer_read_bytes_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_writer_strobe_read_bytes_method_state : std_logic := '0';
  signal this_input_port_emit_command_length_field_wdata_writer_sector_erase_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata_writer_strobe_sector_erase_method_state : std_logic := '0';
  signal this_input_port_emit_command_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_emit_command_addr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal this_input_port_emit_command_addr_field_wdata_writer_page_program_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_writer_strobe_page_program_method_state : std_logic := '0';
  signal this_input_port_emit_command_addr_field_wdata_writer_read_bytes_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_writer_strobe_read_bytes_method_state : std_logic := '0';
  signal this_input_port_emit_command_addr_field_wdata_writer_sector_erase_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata_writer_strobe_sector_erase_method_state : std_logic := '0';
  signal this_input_port_emit_command_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_emit_command_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_emit_command_method_request_field_wdata_reset : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_page_program_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_strobe_page_program_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_read_bytes_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_strobe_read_bytes_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_sector_erase_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_wdata_writer_strobe_sector_erase_method_state : std_logic := '0';
  signal this_emit_command_method_request_field_rdata : std_logic := '0';
  signal this_emit_command_method_request_field_wdata : std_logic := '0';
  signal rom_data_wdata_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_data_wdata_field_wdata_reset_strobe : std_logic := '0';
  signal rom_data_wdata_field_wdata_writer_buf_write_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_data_wdata_field_wdata_writer_strobe_buf_write_method_state : std_logic := '0';
  signal rom_data_wdata_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal rom_data_wdata_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal wait_wip_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_buf_read_method_request : std_logic := '0';
  signal notify_flag : std_logic := '0';
  signal this_input_port_page_program_length : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_request : std_logic := '0';
  signal this_wait_wip_method_busy : std_logic := '0';
  signal state_counter_emit_command_emit_command_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_busy : std_logic := '0';
  signal this_buf_read_method_busy : std_logic := '0';
  signal state_counter_emit_command_emit_command_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_emit_command_emit_command_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_wait_wip_3 : std_logic_vector(2 downto 0) := (others => '0');
  signal state_counter_emit_command_emit_command_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_bytes_read_bytes_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_emit_command_emit_command_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_buf_write_data : std_logic_vector(7 downto 0) := (others => '0');
  signal this_emit_command_call_state_counter_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_buf_write_buf_write_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_buf_write_method_busy : std_logic := '0';
  signal this_input_port_read_bytes_addr : std_logic_vector(31 downto 0) := (others => '0');
  signal this_emit_command_call_state_counter_read_bytes_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal d_notify_flag : std_logic := '0';
  signal state_counter_wait_wip_wait_wip_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_buf_write_method_request : std_logic := '0';
  signal buf_read_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wip_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wip_wait_wip_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal v_buf_read_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal state_counter_wait_wip_wait_wip_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_emit_command_call_state_counter_sector_erase_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_page_program_method_request : std_logic := '0';
  signal this_input_port_read_bytes_length : std_logic_vector(31 downto 0) := (others => '0');
  signal this_sector_erase_method_busy : std_logic := '0';
  signal page_program_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal buf_write_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_buf_read_index : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_page_program_page_program_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal sector_erase_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_buf_read_buf_read_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_wip_call_state_counter_sector_erase_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal v_wait_wip_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_emit_command_call_state_counter_page_program_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal wait_wip_if_flag_wait_wip_5_wait_wip_2 : std_logic := '0';
  signal read_bytes_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sector_erase_sector_erase_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal emit_command_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_read_bytes_method_busy : std_logic := '0';
  signal this_wait_method_busy : std_logic := '0';
  signal this_emit_command_method_busy : std_logic := '0';
  signal this_page_program_method_busy : std_logic := '0';
  signal this_input_port_sector_erase_addr : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_buf_write_index : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_buf_read_1 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_buf_write_1 : std_logic_vector(2 downto 0) := (others => '0');
  signal this_read_bytes_method_request : std_logic := '0';
  signal this_wait_wip_call_state_counter_page_program_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_page_program_addr : std_logic_vector(31 downto 0) := (others => '0');
  signal this_sector_erase_method_request : std_logic := '0';
begin
  U_rom : vhdl_m25p40_buf_wrapper
  port map(
    clk => clk,
    reset => reset,
    M25P40_C => rom_M25P40_C,
    M25P40_DQ0 => rom_M25P40_DQ0,
    M25P40_DQ1 => rom_M25P40_DQ1,
    M25P40_S => rom_M25P40_S,
    req => rom_req_field_rdata,
    busy => rom_busy_field_wdata,
    command => rom_command_field_rdata,
    addr => rom_addr_field_rdata,
    length => rom_length_field_rdata,
    data_waddr => rom_data_waddr_field_rdata,
    data_wdata => rom_data_wdata_field_rdata,
    data_we => rom_data_we_field_rdata,
    data_raddr => rom_data_raddr_field_rdata,
    data_rdata => rom_data_rdata_field_wdata
  );
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  this_input_port_buf_write_index <= conv_std_logic_vector(conv_integer(input_port_buf_write_index), this_input_port_buf_write_index'length);
  this_input_port_buf_write_data <= conv_std_logic_vector(conv_integer(input_port_buf_write_data), this_input_port_buf_write_data'length);
  this_buf_write_method_request <= buf_write_method_request;
  buf_write_method_busy <= this_buf_write_method_busy;
  this_input_port_buf_read_index <= conv_std_logic_vector(conv_integer(input_port_buf_read_index), this_input_port_buf_read_index'length);
  this_buf_read_method_request <= buf_read_method_request;
  buf_read_method_busy <= this_buf_read_method_busy;
  this_input_port_sector_erase_addr <= conv_std_logic_vector(conv_integer(input_port_sector_erase_addr), this_input_port_sector_erase_addr'length);
  this_sector_erase_method_request <= sector_erase_method_request;
  sector_erase_method_busy <= this_sector_erase_method_busy;
  this_input_port_page_program_addr <= conv_std_logic_vector(conv_integer(input_port_page_program_addr), this_input_port_page_program_addr'length);
  this_input_port_page_program_length <= conv_std_logic_vector(conv_integer(input_port_page_program_length), this_input_port_page_program_length'length);
  this_page_program_method_request <= page_program_method_request;
  page_program_method_busy <= this_page_program_method_busy;
  this_input_port_read_bytes_addr <= conv_std_logic_vector(conv_integer(input_port_read_bytes_addr), this_input_port_read_bytes_addr'length);
  this_input_port_read_bytes_length <= conv_std_logic_vector(conv_integer(input_port_read_bytes_length), this_input_port_read_bytes_length'length);
  this_read_bytes_method_request <= read_bytes_method_request;
  read_bytes_method_busy <= this_read_bytes_method_busy;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_length_field_wdata <= rom_length_field_wdata_reset;
      elsif (rom_length_field_wdata_reset_strobe = '1') then
        rom_length_field_wdata <= rom_length_field_wdata_reset;
      elsif (rom_length_field_wdata_writer_strobe_emit_command_method_state = '1') then
        rom_length_field_wdata <= rom_length_field_wdata_writer_emit_command_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_length_field_wdata_reset_strobe <= '1';
      else
        rom_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(emit_command_method_state) = 4) then
        rom_length_field_wdata_writer_strobe_emit_command_method_state <= '1';
      else
        rom_length_field_wdata_writer_strobe_emit_command_method_state <= '0';
      end if;
    end if;
  end process;
  rom_length_field_rdata <= rom_length_field_wdata_reset when (reset = '1') else
        rom_length_field_wdata_reset when (rom_length_field_wdata_reset_strobe = '1') else
        rom_length_field_wdata_writer_emit_command_method_state when (rom_length_field_wdata_writer_strobe_emit_command_method_state = '1') else
        rom_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_waddr_field_wdata <= rom_data_waddr_field_wdata_reset;
      elsif (rom_data_waddr_field_wdata_reset_strobe = '1') then
        rom_data_waddr_field_wdata <= rom_data_waddr_field_wdata_reset;
      elsif (rom_data_waddr_field_wdata_writer_strobe_buf_write_method_state = '1') then
        rom_data_waddr_field_wdata <= rom_data_waddr_field_wdata_writer_buf_write_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_waddr_field_wdata_reset_strobe <= '1';
      else
        rom_data_waddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(buf_write_method_state) = 2) then
        rom_data_waddr_field_wdata_writer_strobe_buf_write_method_state <= '1';
      else
        rom_data_waddr_field_wdata_writer_strobe_buf_write_method_state <= '0';
      end if;
    end if;
  end process;
  rom_data_waddr_field_rdata <= rom_data_waddr_field_wdata_reset when (reset = '1') else
        rom_data_waddr_field_wdata_reset when (rom_data_waddr_field_wdata_reset_strobe = '1') else
        rom_data_waddr_field_wdata_writer_buf_write_method_state when (rom_data_waddr_field_wdata_writer_strobe_buf_write_method_state = '1') else
        rom_data_waddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_command_field_wdata <= rom_command_field_wdata_reset;
      elsif (rom_command_field_wdata_reset_strobe = '1') then
        rom_command_field_wdata <= rom_command_field_wdata_reset;
      elsif (rom_command_field_wdata_writer_strobe_emit_command_method_state = '1') then
        rom_command_field_wdata <= rom_command_field_wdata_writer_emit_command_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_command_field_wdata_reset_strobe <= '1';
      else
        rom_command_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(emit_command_method_state) = 2) then
        rom_command_field_wdata_writer_strobe_emit_command_method_state <= '1';
      else
        rom_command_field_wdata_writer_strobe_emit_command_method_state <= '0';
      end if;
    end if;
  end process;
  rom_command_field_rdata <= rom_command_field_wdata_reset when (reset = '1') else
        rom_command_field_wdata_reset when (rom_command_field_wdata_reset_strobe = '1') else
        rom_command_field_wdata_writer_emit_command_method_state when (rom_command_field_wdata_writer_strobe_emit_command_method_state = '1') else
        rom_command_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_we_field_wdata <= rom_data_we_field_wdata_reset;
      elsif (rom_data_we_field_wdata_reset_strobe = '1') then
        rom_data_we_field_wdata <= rom_data_we_field_wdata_reset;
      elsif (rom_data_we_field_wdata_writer_strobe_buf_write_method_state = '1') then
        rom_data_we_field_wdata <= rom_data_we_field_wdata_writer_buf_write_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_we_field_wdata_reset_strobe <= '1';
      else
        rom_data_we_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(buf_write_method_state) = 2) then
        rom_data_we_field_wdata_writer_strobe_buf_write_method_state <= '1';
      else
        rom_data_we_field_wdata_writer_strobe_buf_write_method_state <= '0';
      end if;
    end if;
  end process;
  rom_data_we_field_rdata <= rom_data_we_field_wdata_reset when (reset = '1') else
        rom_data_we_field_wdata_reset when (rom_data_we_field_wdata_reset_strobe = '1') else
        rom_data_we_field_wdata_writer_buf_write_method_state when (rom_data_we_field_wdata_writer_strobe_buf_write_method_state = '1') else
        rom_data_we_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_req_field_wdata <= rom_req_field_wdata_reset;
      elsif (rom_req_field_wdata_reset_strobe = '1') then
        rom_req_field_wdata <= rom_req_field_wdata_reset;
      elsif (rom_req_field_wdata_writer_strobe_emit_command_method_state = '1') then
        rom_req_field_wdata <= rom_req_field_wdata_writer_emit_command_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_req_field_wdata_reset_strobe <= '1';
      else
        rom_req_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(emit_command_method_state) = 6 or conv_integer(emit_command_method_state) = 7) then
        rom_req_field_wdata_writer_strobe_emit_command_method_state <= '1';
      else
        rom_req_field_wdata_writer_strobe_emit_command_method_state <= '0';
      end if;
    end if;
  end process;
  rom_req_field_rdata <= rom_req_field_wdata_reset when (reset = '1') else
        rom_req_field_wdata_reset when (rom_req_field_wdata_reset_strobe = '1') else
        rom_req_field_wdata_writer_emit_command_method_state when (rom_req_field_wdata_writer_strobe_emit_command_method_state = '1') else
        rom_req_field_wdata;
  
  rom_data_rdata_field_rdata <= rom_data_rdata_field_wdata;
  
  rom_busy_field_rdata <= rom_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_addr_field_wdata <= rom_addr_field_wdata_reset;
      elsif (rom_addr_field_wdata_reset_strobe = '1') then
        rom_addr_field_wdata <= rom_addr_field_wdata_reset;
      elsif (rom_addr_field_wdata_writer_strobe_emit_command_method_state = '1') then
        rom_addr_field_wdata <= rom_addr_field_wdata_writer_emit_command_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_addr_field_wdata_reset_strobe <= '1';
      else
        rom_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(emit_command_method_state) = 3) then
        rom_addr_field_wdata_writer_strobe_emit_command_method_state <= '1';
      else
        rom_addr_field_wdata_writer_strobe_emit_command_method_state <= '0';
      end if;
    end if;
  end process;
  rom_addr_field_rdata <= rom_addr_field_wdata_reset when (reset = '1') else
        rom_addr_field_wdata_reset when (rom_addr_field_wdata_reset_strobe = '1') else
        rom_addr_field_wdata_writer_emit_command_method_state when (rom_addr_field_wdata_writer_strobe_emit_command_method_state = '1') else
        rom_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_reset;
      elsif (this_input_port_emit_command_command_field_wdata_reset_strobe = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_reset;
      elsif (this_input_port_emit_command_command_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_writer_state_counter_wait_wip_wait_wip_2;
      elsif (this_input_port_emit_command_command_field_wdata_writer_strobe_page_program_method_state = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_writer_page_program_method_state;
      elsif (this_input_port_emit_command_command_field_wdata_writer_strobe_read_bytes_method_state = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_writer_read_bytes_method_state;
      elsif (this_input_port_emit_command_command_field_wdata_writer_strobe_sector_erase_method_state = '1') then
        this_input_port_emit_command_command_field_wdata <= this_input_port_emit_command_command_field_wdata_writer_sector_erase_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_command_field_wdata_reset_strobe <= '1';
      else
        this_input_port_emit_command_command_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_wait_wip_wait_wip_2) = 1) then
        this_input_port_emit_command_command_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '1';
      else
        this_input_port_emit_command_command_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '0';
      end if;
      if (conv_integer(page_program_method_state) = 2 or conv_integer(page_program_method_state) = 3) then
        this_input_port_emit_command_command_field_wdata_writer_strobe_page_program_method_state <= '1';
      else
        this_input_port_emit_command_command_field_wdata_writer_strobe_page_program_method_state <= '0';
      end if;
      if (conv_integer(read_bytes_method_state) = 2) then
        this_input_port_emit_command_command_field_wdata_writer_strobe_read_bytes_method_state <= '1';
      else
        this_input_port_emit_command_command_field_wdata_writer_strobe_read_bytes_method_state <= '0';
      end if;
      if (conv_integer(sector_erase_method_state) = 2 or conv_integer(sector_erase_method_state) = 3) then
        this_input_port_emit_command_command_field_wdata_writer_strobe_sector_erase_method_state <= '1';
      else
        this_input_port_emit_command_command_field_wdata_writer_strobe_sector_erase_method_state <= '0';
      end if;
    end if;
  end process;
  this_input_port_emit_command_command_field_rdata <= this_input_port_emit_command_command_field_wdata_reset when (reset = '1') else
        this_input_port_emit_command_command_field_wdata_reset when (this_input_port_emit_command_command_field_wdata_reset_strobe = '1') else
        this_input_port_emit_command_command_field_wdata_writer_state_counter_wait_wip_wait_wip_2 when (this_input_port_emit_command_command_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') else
        this_input_port_emit_command_command_field_wdata_writer_page_program_method_state when (this_input_port_emit_command_command_field_wdata_writer_strobe_page_program_method_state = '1') else
        this_input_port_emit_command_command_field_wdata_writer_read_bytes_method_state when (this_input_port_emit_command_command_field_wdata_writer_strobe_read_bytes_method_state = '1') else
        this_input_port_emit_command_command_field_wdata_writer_sector_erase_method_state when (this_input_port_emit_command_command_field_wdata_writer_strobe_sector_erase_method_state = '1') else
        this_input_port_emit_command_command_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_wip_method_request_field_wdata <= this_wait_wip_method_request_field_wdata_reset;
      elsif (this_wait_wip_method_request_field_wdata_reset_strobe = '1') then
        this_wait_wip_method_request_field_wdata <= this_wait_wip_method_request_field_wdata_reset;
      elsif (this_wait_wip_method_request_field_wdata_writer_strobe_page_program_method_state = '1') then
        this_wait_wip_method_request_field_wdata <= this_wait_wip_method_request_field_wdata_writer_page_program_method_state;
      elsif (this_wait_wip_method_request_field_wdata_writer_strobe_sector_erase_method_state = '1') then
        this_wait_wip_method_request_field_wdata <= this_wait_wip_method_request_field_wdata_writer_sector_erase_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_wip_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_wip_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(page_program_method_state) = 4 or conv_integer(page_program_method_state) = 4) then
        this_wait_wip_method_request_field_wdata_writer_strobe_page_program_method_state <= '1';
      else
        this_wait_wip_method_request_field_wdata_writer_strobe_page_program_method_state <= '0';
      end if;
      if (conv_integer(sector_erase_method_state) = 4 or conv_integer(sector_erase_method_state) = 4) then
        this_wait_wip_method_request_field_wdata_writer_strobe_sector_erase_method_state <= '1';
      else
        this_wait_wip_method_request_field_wdata_writer_strobe_sector_erase_method_state <= '0';
      end if;
    end if;
  end process;
  this_wait_wip_method_request_field_rdata <= this_wait_wip_method_request_field_wdata_reset when (reset = '1') else
        this_wait_wip_method_request_field_wdata_reset when (this_wait_wip_method_request_field_wdata_reset_strobe = '1') else
        this_wait_wip_method_request_field_wdata_writer_page_program_method_state when (this_wait_wip_method_request_field_wdata_writer_strobe_page_program_method_state = '1') else
        this_wait_wip_method_request_field_wdata_writer_sector_erase_method_state when (this_wait_wip_method_request_field_wdata_writer_strobe_sector_erase_method_state = '1') else
        this_wait_wip_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_raddr_field_wdata <= rom_data_raddr_field_wdata_reset;
      elsif (rom_data_raddr_field_wdata_reset_strobe = '1') then
        rom_data_raddr_field_wdata <= rom_data_raddr_field_wdata_reset;
      elsif (rom_data_raddr_field_wdata_writer_strobe_buf_read_method_state = '1') then
        rom_data_raddr_field_wdata <= rom_data_raddr_field_wdata_writer_buf_read_method_state;
      elsif (rom_data_raddr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') then
        rom_data_raddr_field_wdata <= rom_data_raddr_field_wdata_writer_state_counter_wait_wip_wait_wip_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_raddr_field_wdata_reset_strobe <= '1';
      else
        rom_data_raddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(buf_read_method_state) = 2) then
        rom_data_raddr_field_wdata_writer_strobe_buf_read_method_state <= '1';
      else
        rom_data_raddr_field_wdata_writer_strobe_buf_read_method_state <= '0';
      end if;
      if (conv_integer(state_counter_wait_wip_wait_wip_2) = 2) then
        rom_data_raddr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '1';
      else
        rom_data_raddr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '0';
      end if;
    end if;
  end process;
  rom_data_raddr_field_rdata <= rom_data_raddr_field_wdata_reset when (reset = '1') else
        rom_data_raddr_field_wdata_reset when (rom_data_raddr_field_wdata_reset_strobe = '1') else
        rom_data_raddr_field_wdata_writer_buf_read_method_state when (rom_data_raddr_field_wdata_writer_strobe_buf_read_method_state = '1') else
        rom_data_raddr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 when (rom_data_raddr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') else
        rom_data_raddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_reset;
      elsif (this_input_port_emit_command_length_field_wdata_reset_strobe = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_reset;
      elsif (this_input_port_emit_command_length_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_writer_state_counter_wait_wip_wait_wip_2;
      elsif (this_input_port_emit_command_length_field_wdata_writer_strobe_page_program_method_state = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_writer_page_program_method_state;
      elsif (this_input_port_emit_command_length_field_wdata_writer_strobe_read_bytes_method_state = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_writer_read_bytes_method_state;
      elsif (this_input_port_emit_command_length_field_wdata_writer_strobe_sector_erase_method_state = '1') then
        this_input_port_emit_command_length_field_wdata <= this_input_port_emit_command_length_field_wdata_writer_sector_erase_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_length_field_wdata_reset_strobe <= '1';
      else
        this_input_port_emit_command_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_wait_wip_wait_wip_2) = 1) then
        this_input_port_emit_command_length_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '1';
      else
        this_input_port_emit_command_length_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '0';
      end if;
      if (conv_integer(page_program_method_state) = 2 or conv_integer(page_program_method_state) = 3) then
        this_input_port_emit_command_length_field_wdata_writer_strobe_page_program_method_state <= '1';
      else
        this_input_port_emit_command_length_field_wdata_writer_strobe_page_program_method_state <= '0';
      end if;
      if (conv_integer(read_bytes_method_state) = 2) then
        this_input_port_emit_command_length_field_wdata_writer_strobe_read_bytes_method_state <= '1';
      else
        this_input_port_emit_command_length_field_wdata_writer_strobe_read_bytes_method_state <= '0';
      end if;
      if (conv_integer(sector_erase_method_state) = 2 or conv_integer(sector_erase_method_state) = 3) then
        this_input_port_emit_command_length_field_wdata_writer_strobe_sector_erase_method_state <= '1';
      else
        this_input_port_emit_command_length_field_wdata_writer_strobe_sector_erase_method_state <= '0';
      end if;
    end if;
  end process;
  this_input_port_emit_command_length_field_rdata <= this_input_port_emit_command_length_field_wdata_reset when (reset = '1') else
        this_input_port_emit_command_length_field_wdata_reset when (this_input_port_emit_command_length_field_wdata_reset_strobe = '1') else
        this_input_port_emit_command_length_field_wdata_writer_state_counter_wait_wip_wait_wip_2 when (this_input_port_emit_command_length_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') else
        this_input_port_emit_command_length_field_wdata_writer_page_program_method_state when (this_input_port_emit_command_length_field_wdata_writer_strobe_page_program_method_state = '1') else
        this_input_port_emit_command_length_field_wdata_writer_read_bytes_method_state when (this_input_port_emit_command_length_field_wdata_writer_strobe_read_bytes_method_state = '1') else
        this_input_port_emit_command_length_field_wdata_writer_sector_erase_method_state when (this_input_port_emit_command_length_field_wdata_writer_strobe_sector_erase_method_state = '1') else
        this_input_port_emit_command_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_reset;
      elsif (this_input_port_emit_command_addr_field_wdata_reset_strobe = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_reset;
      elsif (this_input_port_emit_command_addr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_writer_state_counter_wait_wip_wait_wip_2;
      elsif (this_input_port_emit_command_addr_field_wdata_writer_strobe_page_program_method_state = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_writer_page_program_method_state;
      elsif (this_input_port_emit_command_addr_field_wdata_writer_strobe_read_bytes_method_state = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_writer_read_bytes_method_state;
      elsif (this_input_port_emit_command_addr_field_wdata_writer_strobe_sector_erase_method_state = '1') then
        this_input_port_emit_command_addr_field_wdata <= this_input_port_emit_command_addr_field_wdata_writer_sector_erase_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_emit_command_addr_field_wdata_reset_strobe <= '1';
      else
        this_input_port_emit_command_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_wait_wip_wait_wip_2) = 1) then
        this_input_port_emit_command_addr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '1';
      else
        this_input_port_emit_command_addr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '0';
      end if;
      if (conv_integer(page_program_method_state) = 2 or conv_integer(page_program_method_state) = 3) then
        this_input_port_emit_command_addr_field_wdata_writer_strobe_page_program_method_state <= '1';
      else
        this_input_port_emit_command_addr_field_wdata_writer_strobe_page_program_method_state <= '0';
      end if;
      if (conv_integer(read_bytes_method_state) = 2) then
        this_input_port_emit_command_addr_field_wdata_writer_strobe_read_bytes_method_state <= '1';
      else
        this_input_port_emit_command_addr_field_wdata_writer_strobe_read_bytes_method_state <= '0';
      end if;
      if (conv_integer(sector_erase_method_state) = 2 or conv_integer(sector_erase_method_state) = 3) then
        this_input_port_emit_command_addr_field_wdata_writer_strobe_sector_erase_method_state <= '1';
      else
        this_input_port_emit_command_addr_field_wdata_writer_strobe_sector_erase_method_state <= '0';
      end if;
    end if;
  end process;
  this_input_port_emit_command_addr_field_rdata <= this_input_port_emit_command_addr_field_wdata_reset when (reset = '1') else
        this_input_port_emit_command_addr_field_wdata_reset when (this_input_port_emit_command_addr_field_wdata_reset_strobe = '1') else
        this_input_port_emit_command_addr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 when (this_input_port_emit_command_addr_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') else
        this_input_port_emit_command_addr_field_wdata_writer_page_program_method_state when (this_input_port_emit_command_addr_field_wdata_writer_strobe_page_program_method_state = '1') else
        this_input_port_emit_command_addr_field_wdata_writer_read_bytes_method_state when (this_input_port_emit_command_addr_field_wdata_writer_strobe_read_bytes_method_state = '1') else
        this_input_port_emit_command_addr_field_wdata_writer_sector_erase_method_state when (this_input_port_emit_command_addr_field_wdata_writer_strobe_sector_erase_method_state = '1') else
        this_input_port_emit_command_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_reset;
      elsif (this_emit_command_method_request_field_wdata_reset_strobe = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_reset;
      elsif (this_emit_command_method_request_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_writer_state_counter_wait_wip_wait_wip_2;
      elsif (this_emit_command_method_request_field_wdata_writer_strobe_page_program_method_state = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_writer_page_program_method_state;
      elsif (this_emit_command_method_request_field_wdata_writer_strobe_read_bytes_method_state = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_writer_read_bytes_method_state;
      elsif (this_emit_command_method_request_field_wdata_writer_strobe_sector_erase_method_state = '1') then
        this_emit_command_method_request_field_wdata <= this_emit_command_method_request_field_wdata_writer_sector_erase_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_emit_command_method_request_field_wdata_reset_strobe <= '1';
      else
        this_emit_command_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_wait_wip_wait_wip_2) = 1 or conv_integer(state_counter_wait_wip_wait_wip_2) = 1) then
        this_emit_command_method_request_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '1';
      else
        this_emit_command_method_request_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 <= '0';
      end if;
      if (conv_integer(page_program_method_state) = 2 or conv_integer(page_program_method_state) = 2 or conv_integer(page_program_method_state) = 3 or conv_integer(page_program_method_state) = 3) then
        this_emit_command_method_request_field_wdata_writer_strobe_page_program_method_state <= '1';
      else
        this_emit_command_method_request_field_wdata_writer_strobe_page_program_method_state <= '0';
      end if;
      if (conv_integer(read_bytes_method_state) = 2 or conv_integer(read_bytes_method_state) = 2) then
        this_emit_command_method_request_field_wdata_writer_strobe_read_bytes_method_state <= '1';
      else
        this_emit_command_method_request_field_wdata_writer_strobe_read_bytes_method_state <= '0';
      end if;
      if (conv_integer(sector_erase_method_state) = 2 or conv_integer(sector_erase_method_state) = 2 or conv_integer(sector_erase_method_state) = 3 or conv_integer(sector_erase_method_state) = 3) then
        this_emit_command_method_request_field_wdata_writer_strobe_sector_erase_method_state <= '1';
      else
        this_emit_command_method_request_field_wdata_writer_strobe_sector_erase_method_state <= '0';
      end if;
    end if;
  end process;
  this_emit_command_method_request_field_rdata <= this_emit_command_method_request_field_wdata_reset when (reset = '1') else
        this_emit_command_method_request_field_wdata_reset when (this_emit_command_method_request_field_wdata_reset_strobe = '1') else
        this_emit_command_method_request_field_wdata_writer_state_counter_wait_wip_wait_wip_2 when (this_emit_command_method_request_field_wdata_writer_strobe_state_counter_wait_wip_wait_wip_2 = '1') else
        this_emit_command_method_request_field_wdata_writer_page_program_method_state when (this_emit_command_method_request_field_wdata_writer_strobe_page_program_method_state = '1') else
        this_emit_command_method_request_field_wdata_writer_read_bytes_method_state when (this_emit_command_method_request_field_wdata_writer_strobe_read_bytes_method_state = '1') else
        this_emit_command_method_request_field_wdata_writer_sector_erase_method_state when (this_emit_command_method_request_field_wdata_writer_strobe_sector_erase_method_state = '1') else
        this_emit_command_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_wdata_field_wdata <= rom_data_wdata_field_wdata_reset;
      elsif (rom_data_wdata_field_wdata_reset_strobe = '1') then
        rom_data_wdata_field_wdata <= rom_data_wdata_field_wdata_reset;
      elsif (rom_data_wdata_field_wdata_writer_strobe_buf_write_method_state = '1') then
        rom_data_wdata_field_wdata <= rom_data_wdata_field_wdata_writer_buf_write_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        rom_data_wdata_field_wdata_reset_strobe <= '1';
      else
        rom_data_wdata_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(buf_write_method_state) = 2) then
        rom_data_wdata_field_wdata_writer_strobe_buf_write_method_state <= '1';
      else
        rom_data_wdata_field_wdata_writer_strobe_buf_write_method_state <= '0';
      end if;
    end if;
  end process;
  rom_data_wdata_field_rdata <= rom_data_wdata_field_wdata_reset when (reset = '1') else
        rom_data_wdata_field_wdata_reset when (rom_data_wdata_field_wdata_reset_strobe = '1') else
        rom_data_wdata_field_wdata_writer_buf_write_method_state when (rom_data_wdata_field_wdata_writer_strobe_buf_write_method_state = '1') else
        rom_data_wdata_field_wdata;
  process(clk) --buf_read
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_buf_read_buf_read_0 <= (others => '0');
        v_buf_read_0 <= (others => '0');
        array_index_operation_state_counter_buf_read_1 <= (others => '0');
        this_buf_read_method_busy <= '0';
        buf_read_method_state <= (others => '0');
        output_port_buf_read <= (others => '0');
      else
        case conv_integer(buf_read_method_state) is
          when 0 =>
            if(this_buf_read_method_request = '1') then
              this_buf_read_method_busy <= '1';
              buf_read_method_state <= buf_read_method_state + 1;
            else
              this_buf_read_method_busy <= '0';
            end if;
          when 1 =>
            if(this_buf_read_method_request = '0') then
              buf_read_method_state <= buf_read_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(array_index_operation_state_counter_buf_read_1) is
              when 0 =>
                rom_data_raddr_field_wdata_writer_buf_read_method_state <= conv_std_logic_vector(conv_integer(input_port_buf_read_index), rom_data_raddr_field_wdata'length);
                array_index_operation_state_counter_buf_read_1 <= array_index_operation_state_counter_buf_read_1 + 1;
              when 1 =>
                array_index_operation_state_counter_buf_read_1 <= (others => '0');
                buf_read_method_state <= buf_read_method_state + 1;
              when others => array_index_operation_state_counter_buf_read_1 <= (others => '0');
            end case;
          when 3 => 
            v_buf_read_0 <= conv_std_logic_vector(conv_integer(rom_data_rdata_field_rdata), v_buf_read_0'length);
            buf_read_method_state <= buf_read_method_state + 1;
          when 4 => 
            output_port_buf_read <= conv_std_logic_vector(conv_integer(v_buf_read_0), output_port_buf_read'length);
            buf_read_method_state <= (others => '0');
          when 5 =>
            this_buf_read_method_busy <= '0';
            buf_read_method_state <= (others => '0');
          when others => buf_read_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --buf_read
  process(clk) --wait_wip
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_wait_wip_wait_wip_0 <= (others => '0');
        state_counter_wait_wip_wait_wip_1 <= (others => '0');
        state_counter_wait_wip_wait_wip_2 <= (others => '0');
        this_emit_command_call_state_counter_wait_wip_2 <= (others => '0');
        this_emit_command_call_state_counter_wait_wip_2 <= (others => '0');
        v_wait_wip_2 <= (others => '0');
        array_index_operation_state_counter_wait_wip_3 <= (others => '0');
        state_counter_wait_wip_wait_wip_4 <= (others => '0');
        wait_wip_if_flag_wait_wip_5_wait_wip_2 <= '0';
        this_wait_wip_method_busy <= '0';
        wait_wip_method_state <= (others => '0');
        this_emit_command_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(wait_wip_method_state) is
          when 0 =>
            if(this_wait_wip_method_request_field_rdata = '1') then
              this_wait_wip_method_busy <= '1';
              wait_wip_method_state <= wait_wip_method_state + 1;
            else
              this_wait_wip_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_wip_method_request_field_rdata = '0') then
              wait_wip_method_state <= wait_wip_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_wait_wip_wait_wip_1) is
              when 0 => state_counter_wait_wip_wait_wip_1 <= state_counter_wait_wip_wait_wip_1 + 1;
              when 1 =>
                if (true) then
                  state_counter_wait_wip_wait_wip_1 <= state_counter_wait_wip_wait_wip_1 + 1;
                  state_counter_wait_wip_wait_wip_2 <= conv_std_logic_vector(1, state_counter_wait_wip_wait_wip_2'length);
                else
                  wait_wip_method_state <= wait_wip_method_state + 1;
                  state_counter_wait_wip_wait_wip_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_wait_wip_wait_wip_2) is
                  when 0 => state_counter_wait_wip_wait_wip_2 <= state_counter_wait_wip_wait_wip_2 + 1;
                  when 1 =>
                    case conv_integer(this_emit_command_call_state_counter_wait_wip_2) is
                      when 0 =>
                        if (this_emit_command_method_busy = '0') then
                          this_emit_command_method_request_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= '1';
                          this_emit_command_call_state_counter_wait_wip_2 <= this_emit_command_call_state_counter_wait_wip_2 + 1;
                        end if;
                      when 1 =>
                        this_input_port_emit_command_command_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= conv_std_logic_vector(READ_STATUS_REGISTER, this_input_port_emit_command_command_field_wdata'length);
                        this_input_port_emit_command_addr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= conv_std_logic_vector(0, this_input_port_emit_command_addr_field_wdata'length);
                        this_input_port_emit_command_length_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= conv_std_logic_vector(0, this_input_port_emit_command_length_field_wdata'length);
                        this_emit_command_method_request_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= '0';
                        this_emit_command_call_state_counter_wait_wip_2 <= this_emit_command_call_state_counter_wait_wip_2 + 1;
                      when 2 =>
                        if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                          this_emit_command_call_state_counter_wait_wip_2 <= (others => '0');
                          state_counter_wait_wip_wait_wip_2 <= state_counter_wait_wip_wait_wip_2 + 1;
                        end if;
                      when others => this_emit_command_call_state_counter_wait_wip_2 <= (others => '0');
                    end case;
                  when 2 =>
                    case conv_integer(array_index_operation_state_counter_wait_wip_3) is
                      when 0 =>
                        rom_data_raddr_field_wdata_writer_state_counter_wait_wip_wait_wip_2 <= conv_std_logic_vector(0, rom_data_raddr_field_wdata'length);
                        array_index_operation_state_counter_wait_wip_3 <= array_index_operation_state_counter_wait_wip_3 + 1;
                      when 1 =>
                        array_index_operation_state_counter_wait_wip_3 <= (others => '0');
                        state_counter_wait_wip_wait_wip_2 <= state_counter_wait_wip_wait_wip_2 + 1;
                      when others => array_index_operation_state_counter_wait_wip_3 <= (others => '0');
                    end case;
                  when 3 =>
                    v_wait_wip_2 <= conv_std_logic_vector(conv_integer(rom_data_rdata_field_rdata), v_wait_wip_2'length);
                    state_counter_wait_wip_wait_wip_2 <= state_counter_wait_wip_wait_wip_2 + 1;
                  when 4 =>
                    case conv_integer(state_counter_wait_wip_wait_wip_4) is
                      when 0 => state_counter_wait_wip_wait_wip_4 <= state_counter_wait_wip_wait_wip_4 + 1;
                      when 1 =>
                        if ((conv_integer(v_wait_wip_2 and conv_std_logic_vector(1, 32))) = 0) then
                          wait_wip_if_flag_wait_wip_5_wait_wip_2 <= '1';
                        else
                          wait_wip_if_flag_wait_wip_5_wait_wip_2 <= '0';
                        end if;
                        state_counter_wait_wip_wait_wip_4 <= state_counter_wait_wip_wait_wip_4 + 1;
                      when 2 =>
                        if (wait_wip_if_flag_wait_wip_5_wait_wip_2 = '1') then
                          state_counter_wait_wip_wait_wip_4 <= (others => '0');
                          state_counter_wait_wip_wait_wip_2 <= (others => '0');
                          state_counter_wait_wip_wait_wip_1 <= (others => '0');
                          wait_wip_method_state <= wait_wip_method_state + 1;
                        else
                          state_counter_wait_wip_wait_wip_4 <= state_counter_wait_wip_wait_wip_4 + 1;
                        end if;
                      when 3 =>
                        state_counter_wait_wip_wait_wip_4 <= (others => '0');
                        state_counter_wait_wip_wait_wip_2 <= state_counter_wait_wip_wait_wip_2 + 1;
                      when others =>
                        state_counter_wait_wip_wait_wip_4 <= (others => '0');
                    end case;
                  when 5 =>
                    state_counter_wait_wip_wait_wip_1 <= state_counter_wait_wip_wait_wip_1 + 1;
                    state_counter_wait_wip_wait_wip_2 <= (others => '0');
                  when others => state_counter_wait_wip_wait_wip_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_wait_wip_wait_wip_1 <= (others => '0');
              when others => state_counter_wait_wip_wait_wip_1 <= (others => '0');
            end case;
          when 3 => 
            wait_wip_method_state <= (others => '0');
          when 4 =>
            this_wait_wip_method_busy <= '0';
            wait_wip_method_state <= (others => '0');
          when others => wait_wip_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait_wip
  process(clk) --page_program
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_page_program_page_program_0 <= (others => '0');
        this_emit_command_call_state_counter_page_program_0 <= (others => '0');
        this_emit_command_call_state_counter_page_program_0 <= (others => '0');
        this_emit_command_call_state_counter_page_program_0 <= (others => '0');
        this_emit_command_call_state_counter_page_program_0 <= (others => '0');
        this_wait_wip_call_state_counter_page_program_0 <= (others => '0');
        this_wait_wip_call_state_counter_page_program_0 <= (others => '0');
        this_page_program_method_busy <= '0';
        page_program_method_state <= (others => '0');
        this_emit_command_method_request_field_wdata_reset <= '0';
        this_emit_command_method_request_field_wdata_reset <= '0';
        this_wait_wip_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(page_program_method_state) is
          when 0 =>
            if(this_page_program_method_request = '1') then
              this_page_program_method_busy <= '1';
              page_program_method_state <= page_program_method_state + 1;
            else
              this_page_program_method_busy <= '0';
            end if;
          when 1 =>
            if(this_page_program_method_request = '0') then
              page_program_method_state <= page_program_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(this_emit_command_call_state_counter_page_program_0) is
              when 0 =>
                if (this_emit_command_method_busy = '0') then
                  this_emit_command_method_request_field_wdata_writer_page_program_method_state <= '1';
                  this_emit_command_call_state_counter_page_program_0 <= this_emit_command_call_state_counter_page_program_0 + 1;
                end if;
              when 1 =>
                this_input_port_emit_command_command_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(WRITE_ENABLE, this_input_port_emit_command_command_field_wdata'length);
                this_input_port_emit_command_addr_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(0, this_input_port_emit_command_addr_field_wdata'length);
                this_input_port_emit_command_length_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(0, this_input_port_emit_command_length_field_wdata'length);
                this_emit_command_method_request_field_wdata_writer_page_program_method_state <= '0';
                this_emit_command_call_state_counter_page_program_0 <= this_emit_command_call_state_counter_page_program_0 + 1;
              when 2 =>
                if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                  this_emit_command_call_state_counter_page_program_0 <= (others => '0');
                  page_program_method_state <= page_program_method_state + 1;
                end if;
              when others => this_emit_command_call_state_counter_page_program_0 <= (others => '0');
            end case;
          when 3 => 
            case conv_integer(this_emit_command_call_state_counter_page_program_0) is
              when 0 =>
                if (this_emit_command_method_busy = '0') then
                  this_emit_command_method_request_field_wdata_writer_page_program_method_state <= '1';
                  this_emit_command_call_state_counter_page_program_0 <= this_emit_command_call_state_counter_page_program_0 + 1;
                end if;
              when 1 =>
                this_input_port_emit_command_command_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(PAGE_PROGRAM, this_input_port_emit_command_command_field_wdata'length);
                this_input_port_emit_command_addr_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(conv_integer(input_port_page_program_addr), this_input_port_emit_command_addr_field_wdata'length);
                this_input_port_emit_command_length_field_wdata_writer_page_program_method_state <= conv_std_logic_vector(conv_integer(input_port_page_program_length), this_input_port_emit_command_length_field_wdata'length);
                this_emit_command_method_request_field_wdata_writer_page_program_method_state <= '0';
                this_emit_command_call_state_counter_page_program_0 <= this_emit_command_call_state_counter_page_program_0 + 1;
              when 2 =>
                if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                  this_emit_command_call_state_counter_page_program_0 <= (others => '0');
                  page_program_method_state <= page_program_method_state + 1;
                end if;
              when others => this_emit_command_call_state_counter_page_program_0 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(this_wait_wip_call_state_counter_page_program_0) is
              when 0 =>
                if (this_wait_wip_method_busy = '0') then
                  this_wait_wip_method_request_field_wdata_writer_page_program_method_state <= '1';
                  this_wait_wip_call_state_counter_page_program_0 <= this_wait_wip_call_state_counter_page_program_0 + 1;
                end if;
              when 1 =>
                this_wait_wip_method_request_field_wdata_writer_page_program_method_state <= '0';
                this_wait_wip_call_state_counter_page_program_0 <= this_wait_wip_call_state_counter_page_program_0 + 1;
              when 2 =>
                if (this_wait_wip_method_request_field_wdata = '0' and this_wait_wip_method_busy = '0') then
                  this_wait_wip_call_state_counter_page_program_0 <= (others => '0');
                  page_program_method_state <= page_program_method_state + 1;
                end if;
              when others => this_wait_wip_call_state_counter_page_program_0 <= (others => '0');
            end case;
          when 5 =>
            this_page_program_method_busy <= '0';
            page_program_method_state <= (others => '0');
          when others => page_program_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --page_program
  process(clk) --read_bytes
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_read_bytes_read_bytes_0 <= (others => '0');
        this_emit_command_call_state_counter_read_bytes_0 <= (others => '0');
        this_emit_command_call_state_counter_read_bytes_0 <= (others => '0');
        this_read_bytes_method_busy <= '0';
        read_bytes_method_state <= (others => '0');
        this_emit_command_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(read_bytes_method_state) is
          when 0 =>
            if(this_read_bytes_method_request = '1') then
              this_read_bytes_method_busy <= '1';
              read_bytes_method_state <= read_bytes_method_state + 1;
            else
              this_read_bytes_method_busy <= '0';
            end if;
          when 1 =>
            if(this_read_bytes_method_request = '0') then
              read_bytes_method_state <= read_bytes_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(this_emit_command_call_state_counter_read_bytes_0) is
              when 0 =>
                if (this_emit_command_method_busy = '0') then
                  this_emit_command_method_request_field_wdata_writer_read_bytes_method_state <= '1';
                  this_emit_command_call_state_counter_read_bytes_0 <= this_emit_command_call_state_counter_read_bytes_0 + 1;
                end if;
              when 1 =>
                this_input_port_emit_command_command_field_wdata_writer_read_bytes_method_state <= conv_std_logic_vector(READ_DATA_BYTES, this_input_port_emit_command_command_field_wdata'length);
                this_input_port_emit_command_addr_field_wdata_writer_read_bytes_method_state <= conv_std_logic_vector(conv_integer(input_port_read_bytes_addr), this_input_port_emit_command_addr_field_wdata'length);
                this_input_port_emit_command_length_field_wdata_writer_read_bytes_method_state <= conv_std_logic_vector(conv_integer(input_port_read_bytes_length), this_input_port_emit_command_length_field_wdata'length);
                this_emit_command_method_request_field_wdata_writer_read_bytes_method_state <= '0';
                this_emit_command_call_state_counter_read_bytes_0 <= this_emit_command_call_state_counter_read_bytes_0 + 1;
              when 2 =>
                if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                  this_emit_command_call_state_counter_read_bytes_0 <= (others => '0');
                  read_bytes_method_state <= read_bytes_method_state + 1;
                end if;
              when others => this_emit_command_call_state_counter_read_bytes_0 <= (others => '0');
            end case;
          when 3 =>
            this_read_bytes_method_busy <= '0';
            read_bytes_method_state <= (others => '0');
          when others => read_bytes_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --read_bytes
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
  process(clk) --sector_erase
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_sector_erase_sector_erase_0 <= (others => '0');
        this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
        this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
        this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
        this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
        this_wait_wip_call_state_counter_sector_erase_0 <= (others => '0');
        this_wait_wip_call_state_counter_sector_erase_0 <= (others => '0');
        this_sector_erase_method_busy <= '0';
        sector_erase_method_state <= (others => '0');
        this_emit_command_method_request_field_wdata_reset <= '0';
        this_emit_command_method_request_field_wdata_reset <= '0';
        this_wait_wip_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(sector_erase_method_state) is
          when 0 =>
            if(this_sector_erase_method_request = '1') then
              this_sector_erase_method_busy <= '1';
              sector_erase_method_state <= sector_erase_method_state + 1;
            else
              this_sector_erase_method_busy <= '0';
            end if;
          when 1 =>
            if(this_sector_erase_method_request = '0') then
              sector_erase_method_state <= sector_erase_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(this_emit_command_call_state_counter_sector_erase_0) is
              when 0 =>
                if (this_emit_command_method_busy = '0') then
                  this_emit_command_method_request_field_wdata_writer_sector_erase_method_state <= '1';
                  this_emit_command_call_state_counter_sector_erase_0 <= this_emit_command_call_state_counter_sector_erase_0 + 1;
                end if;
              when 1 =>
                this_input_port_emit_command_command_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(WRITE_ENABLE, this_input_port_emit_command_command_field_wdata'length);
                this_input_port_emit_command_addr_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(0, this_input_port_emit_command_addr_field_wdata'length);
                this_input_port_emit_command_length_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(0, this_input_port_emit_command_length_field_wdata'length);
                this_emit_command_method_request_field_wdata_writer_sector_erase_method_state <= '0';
                this_emit_command_call_state_counter_sector_erase_0 <= this_emit_command_call_state_counter_sector_erase_0 + 1;
              when 2 =>
                if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                  this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
                  sector_erase_method_state <= sector_erase_method_state + 1;
                end if;
              when others => this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
            end case;
          when 3 => 
            case conv_integer(this_emit_command_call_state_counter_sector_erase_0) is
              when 0 =>
                if (this_emit_command_method_busy = '0') then
                  this_emit_command_method_request_field_wdata_writer_sector_erase_method_state <= '1';
                  this_emit_command_call_state_counter_sector_erase_0 <= this_emit_command_call_state_counter_sector_erase_0 + 1;
                end if;
              when 1 =>
                this_input_port_emit_command_command_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(SECTOR_ERASE, this_input_port_emit_command_command_field_wdata'length);
                this_input_port_emit_command_addr_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(conv_integer(input_port_sector_erase_addr), this_input_port_emit_command_addr_field_wdata'length);
                this_input_port_emit_command_length_field_wdata_writer_sector_erase_method_state <= conv_std_logic_vector(0, this_input_port_emit_command_length_field_wdata'length);
                this_emit_command_method_request_field_wdata_writer_sector_erase_method_state <= '0';
                this_emit_command_call_state_counter_sector_erase_0 <= this_emit_command_call_state_counter_sector_erase_0 + 1;
              when 2 =>
                if (this_emit_command_method_request_field_wdata = '0' and this_emit_command_method_busy = '0') then
                  this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
                  sector_erase_method_state <= sector_erase_method_state + 1;
                end if;
              when others => this_emit_command_call_state_counter_sector_erase_0 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(this_wait_wip_call_state_counter_sector_erase_0) is
              when 0 =>
                if (this_wait_wip_method_busy = '0') then
                  this_wait_wip_method_request_field_wdata_writer_sector_erase_method_state <= '1';
                  this_wait_wip_call_state_counter_sector_erase_0 <= this_wait_wip_call_state_counter_sector_erase_0 + 1;
                end if;
              when 1 =>
                this_wait_wip_method_request_field_wdata_writer_sector_erase_method_state <= '0';
                this_wait_wip_call_state_counter_sector_erase_0 <= this_wait_wip_call_state_counter_sector_erase_0 + 1;
              when 2 =>
                if (this_wait_wip_method_request_field_wdata = '0' and this_wait_wip_method_busy = '0') then
                  this_wait_wip_call_state_counter_sector_erase_0 <= (others => '0');
                  sector_erase_method_state <= sector_erase_method_state + 1;
                end if;
              when others => this_wait_wip_call_state_counter_sector_erase_0 <= (others => '0');
            end case;
          when 5 =>
            this_sector_erase_method_busy <= '0';
            sector_erase_method_state <= (others => '0');
          when others => sector_erase_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --sector_erase
  process(clk) --emit_command
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_emit_command_emit_command_0 <= (others => '0');
        state_counter_emit_command_emit_command_1 <= (others => '0');
        state_counter_emit_command_emit_command_2 <= (others => '0');
        state_counter_emit_command_emit_command_3 <= (others => '0');
        state_counter_emit_command_emit_command_4 <= (others => '0');
        this_emit_command_method_busy <= '0';
        emit_command_method_state <= (others => '0');
        rom_command_field_wdata_reset <= (others => '0');
        rom_addr_field_wdata_reset <= (others => '0');
        rom_length_field_wdata_reset <= (others => '0');
        rom_req_field_wdata_reset <= '0';
      else
        case conv_integer(emit_command_method_state) is
          when 0 =>
            if(this_emit_command_method_request_field_rdata = '1') then
              this_emit_command_method_busy <= '1';
              emit_command_method_state <= emit_command_method_state + 1;
            else
              this_emit_command_method_busy <= '0';
            end if;
          when 1 =>
            if(this_emit_command_method_request_field_rdata = '0') then
              emit_command_method_state <= emit_command_method_state + 1;
            end if;
          when 2 => 
            rom_command_field_wdata_writer_emit_command_method_state <= conv_std_logic_vector(conv_integer(this_input_port_emit_command_command_field_rdata), rom_command_field_wdata'length);
            emit_command_method_state <= emit_command_method_state + 1;
          when 3 => 
            rom_addr_field_wdata_writer_emit_command_method_state <= conv_std_logic_vector(conv_integer(this_input_port_emit_command_addr_field_rdata), rom_addr_field_wdata'length);
            emit_command_method_state <= emit_command_method_state + 1;
          when 4 => 
            rom_length_field_wdata_writer_emit_command_method_state <= conv_std_logic_vector(conv_integer(this_input_port_emit_command_length_field_rdata), rom_length_field_wdata'length);
            emit_command_method_state <= emit_command_method_state + 1;
          when 5 => 
            case conv_integer(state_counter_emit_command_emit_command_1) is
              when 0 => state_counter_emit_command_emit_command_1 <= state_counter_emit_command_emit_command_1 + 1;
              when 1 =>
                if (rom_busy_field_rdata = '1') then
                  state_counter_emit_command_emit_command_1 <= state_counter_emit_command_emit_command_1 + 1;
                  state_counter_emit_command_emit_command_2 <= conv_std_logic_vector(1, state_counter_emit_command_emit_command_2'length);
                else
                  emit_command_method_state <= emit_command_method_state + 1;
                  state_counter_emit_command_emit_command_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_emit_command_emit_command_2) is
                  when 0 => state_counter_emit_command_emit_command_2 <= state_counter_emit_command_emit_command_2 + 1;
                  when 1 =>
                    state_counter_emit_command_emit_command_1 <= state_counter_emit_command_emit_command_1 + 1;
                    state_counter_emit_command_emit_command_2 <= (others => '0');
                  when others => state_counter_emit_command_emit_command_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_emit_command_emit_command_1 <= (others => '0');
              when others => state_counter_emit_command_emit_command_1 <= (others => '0');
            end case;
          when 6 => 
            rom_req_field_wdata_writer_emit_command_method_state <= '1';
            emit_command_method_state <= emit_command_method_state + 1;
          when 7 => 
            rom_req_field_wdata_writer_emit_command_method_state <= '0';
            emit_command_method_state <= emit_command_method_state + 1;
          when 8 => 
            case conv_integer(state_counter_emit_command_emit_command_3) is
              when 0 => state_counter_emit_command_emit_command_3 <= state_counter_emit_command_emit_command_3 + 1;
              when 1 =>
                if (rom_busy_field_rdata = '1') then
                  state_counter_emit_command_emit_command_3 <= state_counter_emit_command_emit_command_3 + 1;
                  state_counter_emit_command_emit_command_4 <= conv_std_logic_vector(1, state_counter_emit_command_emit_command_4'length);
                else
                  emit_command_method_state <= emit_command_method_state + 1;
                  state_counter_emit_command_emit_command_3 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_emit_command_emit_command_4) is
                  when 0 => state_counter_emit_command_emit_command_4 <= state_counter_emit_command_emit_command_4 + 1;
                  when 1 =>
                    state_counter_emit_command_emit_command_3 <= state_counter_emit_command_emit_command_3 + 1;
                    state_counter_emit_command_emit_command_4 <= (others => '0');
                  when others => state_counter_emit_command_emit_command_4 <= (others => '0');
                end case;
              when 3 =>
                state_counter_emit_command_emit_command_3 <= (others => '0');
              when others => state_counter_emit_command_emit_command_3 <= (others => '0');
            end case;
          when 9 => 
            emit_command_method_state <= (others => '0');
          when 10 =>
            this_emit_command_method_busy <= '0';
            emit_command_method_state <= (others => '0');
          when others => emit_command_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --emit_command
  process(clk) --buf_write
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_buf_write_buf_write_0 <= (others => '0');
        array_index_operation_state_counter_buf_write_1 <= (others => '0');
        this_buf_write_method_busy <= '0';
        buf_write_method_state <= (others => '0');
        rom_data_wdata_field_wdata_reset <= (others => '0');
      else
        case conv_integer(buf_write_method_state) is
          when 0 =>
            if(this_buf_write_method_request = '1') then
              this_buf_write_method_busy <= '1';
              buf_write_method_state <= buf_write_method_state + 1;
            else
              this_buf_write_method_busy <= '0';
            end if;
          when 1 =>
            if(this_buf_write_method_request = '0') then
              buf_write_method_state <= buf_write_method_state + 1;
            end if;
          when 2 => 
            rom_data_waddr_field_wdata_writer_buf_write_method_state <= conv_std_logic_vector(conv_integer(input_port_buf_write_index), rom_data_waddr_field_wdata'length);
            rom_data_we_field_wdata_writer_buf_write_method_state <= conv_std_logic_vector(1, rom_data_we_field_wdata'length);
            rom_data_wdata_field_wdata_writer_buf_write_method_state <= conv_std_logic_vector(conv_integer(input_port_buf_write_data), rom_data_wdata_field_wdata'length);
            buf_write_method_state <= buf_write_method_state + 1;
          when 4 =>
            this_buf_write_method_busy <= '0';
            buf_write_method_state <= (others => '0');
          when others => buf_write_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --buf_write
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
end RTL;
