require 'java'

require 'import'
require 'menubox'
require 'caret'
require 'menubar'

import 'java.io.IOException'
import 'java.io.FileInputStream'
import 'java.io.FileOutputStream'

import 'javax.swing.text.rtf.RTFEditorKit'

class TextPane

  def initialize
    @frame = JFrame.new
    @frame.setTitle("TextPane")
    @frame.setBounds( 10, 10, 300, 200)
    @menubox = MenuBox.new(self)
    @frame.getContentPane().add(@menubox.tool_bar, BorderLayout::NORTH);
    @area = JTextPane.new
    scroll = JScrollPane.new(@area,
                             JScrollPane::VERTICAL_SCROLLBAR_ALWAYS, 
                             JScrollPane::HORIZONTAL_SCROLLBAR_NEVER)
    @frame.getContentPane.add(scroll, BorderLayout::CENTER)
    @area.addCaretListener(caret = CaretInfo.new(self))
    @frame.getContentPane().add(caret.disp, BorderLayout::SOUTH)
    caret.add_caret_event_target(@menubox)

    menubar = MenuBar.new(self)
    @frame.setJMenuBar(menubar.menuBar);

    @frame.setDefaultCloseOperation(JFrame::EXIT_ON_CLOSE)
    @frame.setVisible(true)
    new_document
  end
  attr_reader :frame

  def set_text_pane(attr)
    s = @area.getSelectionStart()
    e = @area.getSelectionEnd()
    @doc.setCharacterAttributes(s, e - s, attr, false)
    @area.requestFocusInWindow()
  end

  def new_document
    @sc = StyleContext.new
    @doc = DefaultStyledDocument.new(@sc)
    @area.setDocument(@doc)
    return @doc
  end

  def set_document(doc)
    @doc = doc
    @area.setDocument(@doc)
    return @doc
  end

  def open_document(file)
    doc = DefaultStyledDocument.new(@sc)
    begin
      is = FileInputStream.new(file);
      RTFEditorKit.new().read(is, doc, 0);
      is.close();
    rescue IOException => ex
      ex.printStackTrace;
    end
    set_document(doc);
  end

  def save_document(file)
    begin
      os = FileOutputStream.new(file);
      RTFEditorKit.new().write(os, @doc, 0, @doc.getLength());
      os.close();
    rescue IOException => ex
      ex.printStackTrace
    end
  end

  def insert_string(index, str)
    begin
      @doc.insertString(index, str, @sc.getStyle(StyleContext::DEFAULT_STYLE));
    rescue BadLocationException => e
      put("文書の読み込みに失敗しました。");
    end
  end

  def to_bold(start, length)
    attr = SimpleAttributeSet.new
    StyleConstants::setBold(attr, true)
    # 4文字目から8文字分だけスタイルを変更する
    @doc.setCharacterAttributes(start, start + length, attr, false)
  end

  def get_selected_start
    return @area.getSelectionStart()
  end

  def get_selected_end
    return @area.getSelectionEnd()
  end

  def get_text(start, length)
    return @doc.getText(start, length)
  end

  def get_attribute(index)
    return @doc.getCharacterElement(index).getAttributes()
  end

end

@test = TextPane.new()

load("./test.rb")
